
-- DE15481: Use a dedicated DateTime column in Installation for DateTime values.

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'InsDateTimeValue' AND object_id = OBJECT_ID(N'Installation'))
BEGIN
  ALTER TABLE Installation ADD InsDateTimeValue [DateTime]
END
GO


IF ( (SELECT count(*) FROM Installation WHERE INSSECTION = 'CALLBACKS' AND INSIDENT = 'LAST_REASSIGNMENT_JOB_TIME') = 0 )
BEGIN
  INSERT INTO [Installation] ([INSSECTION], [INSIDENT], [INSVALUE], [projectId], [modifiedBy], [modified], [InsDateTimeValue])
  VALUES ('CALLBACKS', 'LAST_REASSIGNMENT_JOB_TIME', GETUTCDATE(), 0, 0, GETUTCDATE(), GETUTCDATE() )
END ELSE BEGIN
  UPDATE Installation
  SET InsDateTimeValue = GetUTCDate() WHERE INSSECTION = 'CALLBACKS' AND INSIDENT = 'LAST_REASSIGNMENT_JOB_TIME'
END;
GO
